clc; clear; 

%% Problem Data
n = 2;

Q = [0.3   -0.7
    -0.7    2.0];

h  = [-1; .1];

x0 = [-1; 1];


  
% Computing the feasible set
n_poly = 5;
A = zeros(n_poly,2);
b = zeros(n_poly,1);

theta_poly = (0:(2*pi)/n_poly:2*pi);
x_poly = cos(theta_poly);
y_poly = 1.5*sin(theta_poly-pi/10);

for i = 1:n_poly

    p = [x_poly(i+1)-x_poly(i)
         y_poly(i+1)-y_poly(i)];

    a = [p(2),-p(1)];
    a = a/norm(a);

    A(i,:) = a;

    b(i) = a*[x_poly(i); y_poly(i)];

end



%% Algorithm

options = optimoptions('quadprog','Display','off');
x_qp = quadprog(Q,h,[],[],[],[],[],[],x0,options);

% grad descent
[x_gd,data,k] = Gradient_Descent(@(x)(objective(x,Q,h)),Q,h,x0);

fprintf('Solution\n  QuadProg     GD\n')
disp([x_qp,x_gd])

%% Plotting


% Plot the QP
figure(1),clf, hold on, box on
obj = @(x,y) 0.5*[x;y]'*Q*[x;y] + h'*[x;y];
fcontour(obj,'--','LineWidth',2)
colorbar

% Plot the optimum computed via matlab solver
plot(x_qp(1),x_qp(2),"pentagram",'MarkerSize',10,'MarkerFaceColor','b')


% Plot the iterates and search directions

for i= 1:k-1
    plot(data.x(1,i),data.x(2,i),'ko','MarkerFaceColor','k')
    quiver(data.x(1,i),data.x(2,i),+data.d(1,i),+data.d(2,i),0)
    pause(0.1)
end

%% Plot constraints

% plotregion(-A,-b,[],[],[0.8,0.8,0.8]); % plot the feasible region


